<?php

class ImageLogo
{
  public $logofile;
  public $ratio = 1;
  public $location = array('x' => '', 'y' => '');
  public $padding = 0;
  
  public function process($gd_img)
  {
    if ($this->logofile)
    {
      require_once 'class.WebImage.php';

      // adowanie logo
      $logo = new WebImage();
      $logo->load($this->logofile);

      // Jeeli to konieczne, zmiana wielkoci logo
      if ($this->ratio and $this->ratio != 1)
      {
        $logo->resize($this->ratio);
      }

      // Okrelenie umiescowienia logo (x)
      switch ($this->location['x'])
      {
        case 'l':
          $logo_x = $this->padding;
          break;
        case 'r':
          $logo_x = imagesx($gd_img) - 
                    $this->padding - 
                    imagesx($logo->gdresource);
          break;
        default:
          $logo_x = round((imagesx($gd_img) / 2) -
                          (imagesx($logo->gdresource) / 2));
      }
            
      // Okrelenie umiejscowienia logo (y)
      switch ($this->location['y'])
      {
        case 't':
          $logo_y = $this->padding;
          break;
        case 'b':
          $logo_y = imagesy($gd_img) -
                    $this->padding -
                    imagesy($logo->gdresource);
          break;
        default:
          $logo_y = round((imagesy($gd_img) / 2) -
                          (imagesy($logo->gdresource) / 2));
      }
          
      // Kopiowanie logo na waciwy obrazek
      imagecopy($gd_img,
                $logo->gdresource,
                $logo_x,
                $logo_y,
                0,
                0,
                imagesx($logo->gdresource),
                imagesy($logo->gdresource));
    }

    return $gd_img;
  }
}

?>
